/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.block;

import com.yurtmod.block.BlockTentDoor;
import com.yurtmod.block.BlockUnbreakable;
import com.yurtmod.block.Categories;
import com.yurtmod.block.TileEntityTentDoor;
import com.yurtmod.dimension.TentDimension;
import com.yurtmod.init.Config;
import com.yurtmod.init.Content;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTepeeWall
extends BlockUnbreakable
implements Categories.ITepeeBlock {
    public static final int NUM_TEXTURES = 15;
    private static final int NUM_PATTERNS = 5;
    public static final PropertyInteger TEXTURE = PropertyInteger.func_177719_a((String)"texture", (int)0, (int)14);

    public BlockTepeeWall() {
        super(Material.field_151580_n);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState stateIn) {
        super.func_176213_c(worldIn, pos, stateIn);
        if ((Integer)stateIn.func_177229_b((IProperty)TEXTURE) == 0) {
            IBlockState state;
            BlockPos doorPos = this.findDoorNearby(worldIn, pos);
            if (!TentDimension.isTentDimension(worldIn) && doorPos != null && Math.abs(pos.func_177956_o() - doorPos.func_177956_o()) % 2 == 0) {
                TileEntityTentDoor te = (TileEntityTentDoor)worldIn.func_175625_s(doorPos);
                int randSeed = pos.func_177956_o() + doorPos.func_177958_n() + doorPos.func_177952_p() + te.getOffsetX() * 123 + te.getOffsetZ() * 321;
                state = BlockTepeeWall.getStateForRandomPattern(new Random(randSeed));
            } else {
                state = BlockTepeeWall.getStateForRandomDesignWithChance(worldIn.field_73012_v);
            }
            worldIn.func_180501_a(pos, state, 2);
        }
    }

    public IBlockState onBlockPlaced(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)TEXTURE, (Comparable)Integer.valueOf(meta % 15));
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < 15; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TEXTURE});
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TEXTURE, (Comparable)Integer.valueOf(meta % 15));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TEXTURE);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public static IBlockState getStateForBase() {
        return Content.TEPEE_WALL.func_176223_P().func_177226_a((IProperty)TEXTURE, (Comparable)Integer.valueOf(0));
    }

    public static IBlockState getStateForRandomPattern(Random rand) {
        return Content.TEPEE_WALL.func_176223_P().func_177226_a((IProperty)TEXTURE, (Comparable)Integer.valueOf(rand.nextInt(5) + 1));
    }

    public static IBlockState getStateForRandomDesignWithChance(Random rand) {
        return rand.nextInt(100) < Config.TEPEE_DECORATED_CHANCE ? BlockTepeeWall.getStateForRandomDesign(rand) : BlockTepeeWall.getStateForBase();
    }

    public static IBlockState getStateForRandomDesign(Random rand) {
        int meta = rand.nextInt(9) + 5 + 1;
        return Content.TEPEE_WALL.func_176223_P().func_177226_a((IProperty)TEXTURE, (Comparable)Integer.valueOf(meta % 15));
    }

    private BlockPos findDoorNearby(World world, BlockPos pos) {
        LinkedList checked = new LinkedList();
        while (pos != null && !(world.func_180495_p(pos).func_177230_c() instanceof BlockTentDoor)) {
            pos = this.getNextTepeeBlock(world, checked, pos);
        }
        if (pos == null) {
            return null;
        }
        boolean isLower = world.func_180495_p(pos).func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER;
        return isLower ? pos : pos.func_177979_c(1);
    }

    private BlockPos getNextTepeeBlock(World worldIn, List exclude, BlockPos pos) {
        int radius = 1;
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos checkPos = pos.func_177982_a(x, y, z);
                    IBlockState stateAt = worldIn.func_180495_p(checkPos);
                    if (exclude.contains(checkPos) || !(stateAt.func_177230_c() instanceof Categories.ITepeeBlock) && !(stateAt.func_177230_c() instanceof Categories.IFrameBlock)) continue;
                    exclude.add(checkPos);
                    return checkPos;
                }
            }
        }
        return null;
    }
}

